#include <SMCSMicroReceipt.h>


// forward declarations
void GetMicroReceiptTypeUsage();
void SetMicroReceiptTypeUsage(SMCSMicroReceiptType Type);
void ShowFailureMessage(SMCSMicroReceiptResult smcsresult);


#ifdef _UNICODE

#include <wchar.h>
#include <locale>
using namespace std;

// unicode
#define CONSOLE_OUT wprintf
#define CONSOLE_IN wscanf_s
#define CONSOLE_IN_CHAR getwchar
#define SPRINTF swprintf_s

#define STR_CMP wcscmp
#define STR_TO_INT _wtoi

#define STR_ELEM wchar_t
#define STR(x) L ## x

wchar_t g_printerName[100 + 1] = {0};
wchar_t g_parameters[100 + 1] = { 0 };

int wmain(int argc, wchar_t *argv[], wchar_t *envp[])
{
    std::locale::global(std::locale(""));
#else

#include <stdlib.h>
#include <stdio.h>
#include <ctype.h>
#include <string.h>
//#include <unistd.h>

// ansi
#define CONSOLE_OUT printf
#define CONSOLE_IN scanf_s
#define CONSOLE_IN_CHAR getchar
#define SPRINTF sprintf_s

#define STR_CMP strcmp
#define STR_TO_INT atoi

#define STR_ELEM char
#define STR(x) x

char g_printerName[100 + 1] = {0};
char g_parameters[100 + 1] = { 0 };

int main(int argc, char * argv[])
{
#endif

    CONSOLE_OUT(STR("Enter the printer name: "));
    CONSOLE_IN(STR("%[^\t\n]"), g_printerName, (unsigned)_countof(g_printerName)); CONSOLE_IN_CHAR();
 

    while(true)
    {
        CONSOLE_OUT(STR("[1] Get MicroReceipt\n"));
        CONSOLE_OUT(STR("[2] Set MicroReceipt(Disable) + Test Print\n"));
        CONSOLE_OUT(STR("[3] Set MicroReceipt(Information Logo + QR code)  + Test Print\n"));
        CONSOLE_OUT(STR("[4] Set MicroReceipt(Only QR code)  + Test Print\n"));
        CONSOLE_OUT(STR("[5] Set MicroReceipt(Ondemand Information Logo + QR code)  + Test Print\n"));
        CONSOLE_OUT(STR("[6] Set MicroReceipt(Ondemand Only QR code)  + Test Print\n"));
        CONSOLE_OUT(STR("[x] Quit\n"));

        STR_ELEM answerString[10] ={0};

        CONSOLE_OUT(STR("Select one of the above options: "));
        CONSOLE_IN(STR("%s"), answerString, (unsigned)_countof(answerString)); CONSOLE_IN_CHAR();

        if(STR_CMP(answerString, STR("x")) == 0)
        {
            return 0;
        }

        int answer = STR_TO_INT(answerString);
       
        switch(answer)
        {
        case 1:
              GetMicroReceiptTypeUsage();
            break;
        case 2:
              SetMicroReceiptTypeUsage(DISABLE);
            break;
        case 3:
              SetMicroReceiptTypeUsage(INFORMATION_WITH_QRCODE);
            break;
        case 4:
              SetMicroReceiptTypeUsage(ONLY_QRCODE);
            break;
        case 5:
              SetMicroReceiptTypeUsage(ONDEMAND_INFORMATION_WITH_QRCODE);
            break;
        case 6:
              SetMicroReceiptTypeUsage(ONDEMAND_ONLY_QRCODE);
            break;
        default:
            CONSOLE_OUT(STR("Invalid Option\n"));
            break;
        }

        CONSOLE_OUT(STR("\n"));
    }

    return 0;
}

void ShowFailureMessage(SMCSMicroReceiptResult smcsresult)
{
    switch(smcsresult)
    {
        case SMCS_NOT_REGISTERED: 
          CONSOLE_OUT(STR("Failure - SMCS_NOT_REGISTERED \n")); 
          break;
        case PRINTER_NAME_NOT_FOUND: 
          CONSOLE_OUT(STR("Failure - PRINTER_NAME_NOT_FOUND \n")); 
          break;
        case MICRORECEIPT_PARMETER_NOT_FOUND: 
          CONSOLE_OUT(STR("Failure - MICRORECEIPT_PARMETER_NOT_FOUND \n")); 
          break;
        case SETTING_VALUE_IS_INCORRECT:
          CONSOLE_OUT(STR("Failure - SETTING_VALUE_IS_INCORRECT \n")); 
          break;
        case INITIALIZE_ERROR: 
          CONSOLE_OUT(STR("Failure - INITIALIZE_ERROR \n")); 
          break;
        case XML_FILE_NOT_BE_LOADED: 
          CONSOLE_OUT(STR("Failure - XML_FILE_NOT_BE_LOADED \n")); 
          break;
        case TIMEOUT: 
          CONSOLE_OUT(STR("Failure - TIMEOUT \n")); 
          break;
        case MUTEX_ERROR: 
          CONSOLE_OUT(STR("Failure - TIMEMUTEX_ERROROUT \n")); 
          break;
    }
}
void GetMicroReceiptTypeUsage()
{
    SMCSMicroReceiptResult smcsresult;
    SMCSMicroReceiptType   type;

    smcsresult = GetMicroReceiptType(g_printerName, &type);

    if(smcsresult == SUCCESS)
    {
        switch(type)
        {
            case DISABLE:
                CONSOLE_OUT(STR("Success - Disable\n")); 
                break;
            case INFORMATION_WITH_QRCODE:
                CONSOLE_OUT(STR("Success - Information Logo + QR code\n")); 
                break;
            case ONLY_QRCODE:
                CONSOLE_OUT(STR("Success - QR code\n")); 
                break;
            case ONDEMAND_INFORMATION_WITH_QRCODE:
                CONSOLE_OUT(STR("Success - Ondemand nformation Logo + QR code\n")); 
                break;
            case ONDEMAND_ONLY_QRCODE:
                CONSOLE_OUT(STR("Success - Ondemand QR code\n")); 
                break;
        }
    }
    else
    {
        ShowFailureMessage(smcsresult);
    }
    
    
}

void SetMicroReceiptTypeUsage(SMCSMicroReceiptType Type)
{
    SMCSMicroReceiptResult smcsresult;
    smcsresult = SetMicroReceiptType(g_printerName, Type);

	if (smcsresult == SUCCESS) 
	{
		HANDLE hPrinter = NULL;

		//Check existence of printer queue
		if (OpenPrinter(g_printerName, &hPrinter, NULL) != NULL)
		{
			HINSTANCE instance = NULL;

			//Print Test
			SPRINTF(g_parameters, STR("printui.dll,PrintUIEntry /k /n \"%s\""), g_printerName);

			instance = ShellExecute(0, NULL, STR("rundll32.exe"), g_parameters, NULL, NULL);
		}

		if (hPrinter != NULL)
		{
			ClosePrinter(hPrinter);
		}

		CONSOLE_OUT(STR("Success\n")); 
	}
	else 
	{
		ShowFailureMessage(smcsresult);
	}
}